# 1 分钟生成架构图？程序员 AI 绘图保姆级教程

大家好，我是鱼皮。作为一名程序员，画图可以说是工作中的家常便饭了。无论是给领导汇报时画架构图、还是写文档时画流程图、或者头脑风暴时画思维导图，画图能力直接体现出我们的专业水平。

以前画图需要自己费时费力，一个复杂的架构图可能要花几个小时，还得反复调整；现在喝杯水的功夫，AI 就帮你画好了，而且效果还特别专业！

下面鱼皮将分享 **5 大类 AI 画图方法**，每一种都有详细的保姆级教程，零基础小白也能快速精通 AI 画图之术。这些方法一个比一个猛，建议先点赞收藏，看到最后你会收获满满！以后无论是生成原型图、设计海报，还是程序员常画的架构图、流程图、UML 类图等等，都是洒洒水的事~

⭐️ 推荐观看视频版，有更详细的操作演示：https://bilibili.com/video/BV1DP7JzAE7k/



## 🖌️ 鱼皮的 AI 画图秘术

虽然目前主流的 AI 大模型和工具都能实现画图功能，但我强烈建议使用 **Cursor 工具搭配 Claude 4 大模型**，效果最佳。

在开始之前，我们先了解一下 AI 画图的本质：**其实就是让 AI 生成各种绘图工具能够理解的文本代码**，然后将这些代码导入到对应的工具中进行渲染。这样就能够借助 AI 的创意和工具的能力自由地生成图片。

![](https://pic.yupi.icu/1/1748414656182-9580e13e-97bd-4013-8361-ee19b200c0f7.png)

下面来介绍几类 AI 画图方法：

### 一、文本绘图

文本绘图是最受高级程序员欢迎的画图方式，通过简单的文本描述就能生成专业的技术图。主流的文本绘图语言包括 **Mermaid** 和 **PlantUML**，它们各有特色，适用于不同的场景。

#### 1、Mermaid - 最流行的文本绘图工具

Mermaid 是目前最流行的文本绘图工具，语法简单直观，被 GitHub、语雀等大平台原生支持。无论你是要画软件架构图、业务流程图，还是数据库 ER 图、Git 分支图，Mermaid 都能轻松搞定。

让我们先来画一个用户登录流程图，只需要给 AI 这样的提示词：

```plain
请用 Mermaid 语法帮我画一个用户登录流程图，包含以下步骤：
1. 用户输入账号密码
2. 前端校验格式
3. 发送请求到后端
4. 后端验证用户信息
5. 如果验证成功，生成 token 返回
6. 如果失败，返回错误信息
7. 前端根据结果跳转页面或显示错误
```

放到 Cursor 等 AI 工具中执行：

![](https://pic.yupi.icu/1/1748415863293-79af3d1d-153d-462c-9dd7-ec63eaf6a3dd.png)

AI 会生成这样的代码：

```
flowchart TD
    A[用户输入账号密码] --> B{前端格式校验}
    B -->|格式正确| C[发送登录请求到后端]
    B -->|格式错误| D[显示格式错误提示]
    C --> E{后端验证用户信息}
    E -->|验证成功| F[生成Token]
    F --> G[返回Token给前端]
    G --> H[前端保存Token]
    H --> I[跳转到主页]
    E -->|验证失败| J[返回错误信息]
    J --> K[前端显示错误提示]
    D --> A
    K --> A
```

然后你就可以把代码复制到 Mermaid 渲染工具中，比如写作工具语雀支持添加文本绘图组件：

![](https://pic.yupi.icu/1/1748414852734-6d3b6a1c-c2e8-4454-8e1b-57415f204bab.png)

然后就会出现一个绘图框，在左侧粘贴文本代码，右侧选择对应的绘图语言，就能看到效果了：

![](https://pic.yupi.icu/1/1748414916480-1151faa7-a03d-49b0-82b0-ba321211456e.png)

很多 Markdown 编辑器也天然支持 Mermaid 绘图的渲染，比如 Typora：

![](https://pic.yupi.icu/1/1748415033938-862e8c79-5e83-40ae-a50a-ddd1a56033cd.png)

有很多支持 [Mermaid 渲染的网站](https://mermaid-live.nodejs.cn/edit)，还可以导出为 PNG 等格式的图片：

![](https://pic.yupi.icu/1/1748415174077-04b9d2a2-c655-4a9b-95d9-78f10fb19859.png)

此外，现在很多 AI 聊天助手内置了 Mermaid 渲染工具，能直接看到效果并下载：

![](https://pic.yupi.icu/1/1748415298510-f1389787-6859-4cf6-b0c7-fe6712acf57a.png)

如果你对 AI 生成的效果不满意，只需手动修改文本即可，会自动重新渲染图片。

Mermaid 还支持多种图表类型，比如时序图：

```plain
请用 Mermaid 画一个订单支付的时序图，展示用户、前端、后端、支付网关之间的交互
```

AI 生成的效果如图：

![](https://pic.yupi.icu/1/image-20250530125722186.png)

Mermaid 还能画甘特图、饼图、Git 分支图等，这里再让 AI 生成一个架构图：

```plain
请用 Mermaid 画一个简单的微服务架构图
```

AI 生成的效果如图：

![](https://pic.yupi.icu/1/image-20250530125556460.png)



#### 2、PlantUML - 专业的 UML 绘图工具

PlantUML 是另一个强大的文本绘图工具，特别擅长绘制 UML 图、时序图和系统架构图。它的语法相对 Mermaid 更加专业和规范，生成的图表也更加精美。

让我们用 AI + PlantUML 画一个经典的订单系统类图，给 AI 的提示词如下：

```plain
请用 PlantUML 语法帮我画一个订单系统的类图，包含：
- Order 类：订单ID、用户ID、总金额、状态、创建时间
- OrderItem 类：商品ID、数量、单价
- User 类：用户ID、用户名、邮箱
- Product 类：商品ID、名称、价格、库存
展示它们之间的关联关系
```

AI 会生成专业的 PlantUML 代码，同样放到语雀的文本绘图、或者 [PlantUML 渲染网站](https://www.plantuml.com/plantuml/uml/) 中，都可以看到效果：

![](https://pic.yupi.icu/1/image-20250530125534018.png)

PlantUML 还特别适合画复杂的时序图和系统架构图。比如一个完整的登录时序图：

![](https://pic.yupi.icu/1/image-20250530125546237.png)



#### 其他文本绘图工具

除了 Mermaid 和 PlantUML，还有 **Flowchart** 和 **Graphviz** 等文本绘图工具。为了帮大家更好地选择，我整理了这四种工具的对比：

| 特性         | **Mermaid**              | **PlantUML**      | **Flowchart** | **Graphviz**       |
| ------------ | ------------------------ | ----------------- | ------------- | ------------------ |
| **图表类型** | 流程图、时序图、甘特图等 | UML全系列、架构图 | 流程图        | 各类图表，极其灵活 |
| **语法难度** | 简单直观                 | 中等，UML规范     | 非常简单      | 较复杂             |
| **生态支持** | GitHub/GitLab原生支持    | 需要插件支持      | 一般          | 广泛支持           |
| **定制能力** | 中等                     | 高                | 低            | 极高               |
| **适用场景** | 日常文档配图             | 专业架构设计      | 简单流程说明  | 复杂网络拓扑       |
| **学习成本** | 低                       | 中                | 极低          | 高                 |

我的建议是，日常使用选 Mermaid，因为它语法简单、平台支持好；如果要画专业的 UML 图，就选 PlantUML。如果想生成复杂的网络拓扑图，可以选择 Graphviz，支持更复杂的定制能力。

比如鱼皮给自己的野鱼网吧生成了一份网络拓扑图：

![](https://pic.yupi.icu/1/image-20250530125744125.png)



### 二、网页绘图

网页绘图是一种非常自由灵活的绘图方式。本质上是 “图片即网站” —— 通过生成包含可视化元素的网页代码，在浏览器中渲染出各种图片，而且可以实现静态图片无法做到的交互效果和动画展示。

#### 1、原生网页绘图

利用网站开发的核心技术（HTML + CSS + JavaScript），我们可以生成各种类型的图表。这种方式虽然不是传统意义上的绘图，但效果可能会超出预期。还可以借助各种第三方可视化库（如 ECharts、D3.js 等）来增强效果。

举个例子，当需要展示数据时，AI 可以利用 Apache ECharts 等可视化库生成专业的数据大屏。给 AI 的提示词如下：

```plain
请生成一个数据可视化大屏页面，展示电商平台的实时数据：
1. 页面布局：深色背景的大屏风格，分为头部标题和多个数据展示区域
2. 包含以下图表：
   - 实时销售额（动态数字翻牌效果）
   - 各品类销售占比（饼图）
   - 24小时销售趋势（折线图）
   - 热销商品TOP10（柱状图）
   - 用户地域分布（中国地图热力图）
3. 使用 ECharts 实现，要有动画效果
4. 响应式布局，适配不同屏幕
```

AI 会生成完整的网站，包含各种图表，还是挺炫酷的吧~

![](https://pic.yupi.icu/1/1748417511003-49c81cc8-618e-4810-b94d-ebcfbb48885d.png)

你可以直接按需截图，得到图片；还可以通过 [Codepen](https://codepen.io/) 等网站运行工具将生成的网站快速分享给其他人。

![](https://pic.yupi.icu/1/1748417620327-fb4d8e79-c9f1-4b4d-a362-4c85437b8d02.png)

同理，AI 还能快速生成产品原型图，特别适合快速验证想法。给 AI 的提示词如下：

```plain
你是一位专业的 UI 设计师，请生成一个移动端电商APP的完整原型图，要求：
1. 使用 HTML+CSS 实现，风格简洁现代
2. 在同一个 HTML 页面中生成所有的原型页面，平铺排列
3. 生成的原型图是可以直接提供给前端程序员进行开发的
4. 当你需要图片资源时，优先使用 SVG 格式的图片
```

查看 AI 生成的原型图效果，我着实替 UI 设计师朋友们也捏了一把汗。。。

![](https://pic.yupi.icu/1/1748419658065-db5639fd-0609-431e-a135-0ff6b74e7e2b.png)



#### 2、SVG 矢量图绘制

SVG 是可缩放的矢量图形，SVG 图像可以无限缩放而不失真，非常适合绘制 UI 素材、Logo 图标、图形插画、技术架构图、流程图等需要无损缩放的图片。

SVG 文件本质上是 XML 格式的文本代码，可以直接嵌入网页或导入各种设计工具。

让我们用 SVG 绘制一个系统架构图，给 AI 的提示词如下：

```plain
请生成一个 SVG 格式的系统架构图，展示一个典型的三层架构：
- 展示层：Web 前端、移动端 App
- 业务层：API 服务器集群（3个节点）
- 数据层：主从数据库、Redis 缓存
要求：
- 使用不同颜色区分各层
- 添加连接线表示数据流向
- 图形美观，配色专业
```

AI 生成的 SVG 代码可以直接嵌入网页或导入设计工具，也可以保存为 SVG 文件直接双击在浏览器内打开。效果还不错吧~

![](https://pic.yupi.icu/1/1748419703308-c3e3ab06-bfd0-4d3e-8bd9-6315fe9e3dde.png)

使用 SVG 的另一个优点是可以精确控制每个元素的位置、大小和样式，甚至能添加动画效果，让图片更加生动。



#### 3、Canvas 动态绘图

Canvas 是 HTML5 提供的一个画布元素，通过 JavaScript 可以在上面绘制各种图形。与 SVG 不同，Canvas 是基于像素的，而且性能优秀，适合创建需要精确控制元素细节、动画效果丰富的画面，很多游戏也是基于 Canvas 实现的。

让我们利用 AI + Canvas 绘制一个海报页面，给 AI 的提示词如下：

```plain
请用 HTML5 Canvas 创建一个商务风格的宣传海报：
- 主题：企业网络解决方案
- 布局：上下分层设计，上部分为图形区域，下部分为文字区域
- 核心图形：5个立体感服务器图标，用优雅的曲线连接
- 配色：蓝白配色方案，体现专业感
- 文字内容：公司 Logo、产品名称、核心卖点
- 视觉效果：微妙的阴影和高光，提升质感
- 输出格式：可打印的高分辨率海报
```

生成的效果如图，我感觉还不错，而且还顺便生成了下载海报图片的按钮：

![](https://pic.yupi.icu/1/1748421121147-cec5fbe9-c304-42af-add2-c7986fdec704.png)

再来绘制一个高大上的网络性能监控仪表板，给 AI 的提示词如下：

```html
请用 HTML5 Canvas 创建一个网络性能监控仪表板：
- 设计元素：
  * 中央放置主要的网络拓扑图
  * 周围添加各种图表和数据指标
  * 实时数据流动效果
  * 状态指示灯和进度条
- 配色：深色主题配亮色高亮
- 文字：等宽字体，模拟代码风格
- 细节：添加网格背景和扫描线效果
```

生成的效果很炫酷，非常适合拿来做技术演示（PPT）：

![](https://pic.yupi.icu/1/1748420915939-7aca595e-7ad4-4cbf-b09d-1e66448fb67d.png)



### 三、思维导图

AI 可以帮我们快速生成精美的思维导图，并且能够导出为专业思维导图软件支持的格式，便于我们在学习和工作中梳理知识。

我用的比较多的思维导图软件是 XMind，支持丰富的样式和主题。

可以通过 AI 直接生成 XMind 格式的思维导图代码，提示词如下：

```plain
请帮我生成一个关于"微服务架构设计"的思维导图，要求生成可以导入 XMind 软件的格式。
注意，XMind 文件实际上是一个 ZIP 压缩包，需要包含多个必要的文件。

导图内容包含以下要点：
1. 服务拆分原则
   - 单一职责
   - 服务自治
   - 接口明确
2. 通信机制
   - 同步通信（REST、gRPC）
   - 异步通信（消息队列）
3. 服务治理
   - 服务注册与发现
   - 负载均衡
   - 熔断降级
```

生成的效果还不错，还可以在软件中进一步美化思维导图的样式，图片太长了就给大家看一部分吧~

![](https://pic.yupi.icu/1/1748421899721-db05c840-44ac-439e-bfd3-a012a3631298.png)

不过我更建议让 AI 生成 Markdown 格式的思维导图，因为 Markdown 格式更通用，方便在各种文档工具中使用。给 AI 提供下面这段提示词：

```plain
请将上述微服务架构内容整理成 Markdown 格式的思维导图，使用缩进表示层级关系
```

AI 会生成这样的 Markdown 格式：

```java
# 微服务架构设计

## 服务拆分原则
- 单一职责
  - 每个服务只负责一个业务功能
  - 高内聚低耦合
- 服务自治
  - 独立部署
  - 独立技术选型
  - 独立数据存储
```

将这个 Markdown 文件直接导入 XMind，就能生成结构清晰的思维导图啦！

![](https://pic.yupi.icu/1/1748422118001-752df2f4-d369-46b8-8e16-cd96191d554f.png)



### 四、专业绘图工具

如果将 AI 与专业绘图工具结合，可以实现 1+1 > 2 的效果。

我用的比较多的绘图工具是免费开源的 draw.io，它的优点是 **自由度极高**，支持导入导出多种格式，拥有丰富的图形库和模板。当需要绘制复杂图片时，先让 AI 生成 draw.io 格式的 XML 代码，然后导入到 draw.io 中进行二次编辑，能够大幅提升作图效率。

举个例子，让 AI 为鱼皮在 [编程导航](https://www.codefather.cn) 原创的十几套项目教程生成一个学习路线图：

```plain
请根据下列内容，生成 draw.io 格式的《编程导航原创项目学习路线图》代码：

## 以下是项目学习相关内容
...
...
```

然后直接复制 AI 生成的 XML 代码：

![](https://pic.yupi.icu/1/1748422690362-20c40630-acce-47ea-b35a-09a61f121840.png)

并粘贴到 draw.io 中，就得到了下面这张图，效果还挺不错的吧！

![](https://pic.yupi.icu/1/1748422763122-ee6bcc1a-64cf-4d4d-ad19-6add7ee0706d.png)

然后你可以将绘图导出为各种主流图片格式，甚至是 PDF 文档和 HTML 网页：

![](https://pic.yupi.icu/1/1748423134756-9f5481bc-71a0-4969-96e1-eafdc4855399.png)

再来画一个复杂的架构图吧。让 AI 根据我的《亿级流量点赞系统项目教程》生成对应的架构图，提示词如下：

```xml
请根据下列内容，生成 draw.io 格式的《亿级流量点赞系统的架构图》代码：

## 以下是项目教程相关内容
...
...
```

AI 生成的绘图如下：

![](https://pic.yupi.icu/1/1748423409326-80e0f322-2b6b-434a-8c8e-217008b9124c.png)

是不是挺震撼的？如果人工来画这张图，半条命估计就下去了。

不过我们会发现，AI 有时候生成的图片元素会出现排版错乱、位置对不齐的情况。这时就需要人工进行调整了，有时要改的内容还挺多的，没点儿画图功底还真驾驭不了 AI。

所以虽然 AI + draw.io 这种画图方法看起来最强大，实际上还是建议大家根据作图的类型和复杂度，选择最合适的方法吧。



### 五、Emoji 绘图

还有一些适合整活儿的创意画图方法，比如利用 Emoji 表情来绘制简单的图。

举个例子，使用下面这段提示词：

```plain
利用 Emoji 帮我生成纯文本格式的流程图，要求生动有趣，尽可能多地将文本替换为 Emoji 表示。

提供的内容如下：
开发 -> 测试 -> 部署 -> 监控，循环往复
```

AI 会生成类似这样的效果：

```plain
🔄 软件开发生命周期流程图 🔄

    👨‍💻 开发阶段
         ⬇️
    🧪 测试阶段  
         ⬇️
    🚀 部署阶段
         ⬇️
    📊 监控阶段
         ⬇️
         🔁
    (循环往复)
```

或者这样 👇，这是不是有点太抽象了？？？

```plain
🔄 DevOps 循环

👨‍💻 ➡️ 🧪 ➡️ 🚀 ➡️ 📊
 ⬆️                    ⬇️
 🔁 ⬅️ ⬅️ ⬅️ ⬅️ ⬅️ 🔁
```

还可以用 Emoji 画更复杂的图，比如微服务架构：

```plain
利用 Emoji 帮我生成纯文本格式的微服务架构图，要求生动有趣，尽可能多地将文本替换为 Emoji 表示。
```

AI 会生成这样的效果，抽象，太抽象了！

```plain
🌐 微服务架构全景图 🏗️

                    👥 用户
                      ⬇️
                 🚪 API 网关 🛡️
                      ⬇️
        ┌─────────────┼─────────────┐
        ⬇️            ⬇️            ⬇️
    🛒 订单服务    👤 用户服务    💰 支付服务
        ⬇️            ⬇️            ⬇️
    🗄️ 订单DB     🗄️ 用户DB     🗄️ 支付DB
```

同理，大家还可以尝试下字符画绘图，大胆发挥创意尽情探索、尽情压榨 AI 吧~



## AI 绘图技巧

掌握了基本的绘图方法后，鱼皮再给大家开个小灶，分享一些高级技巧，帮你更快地画出更好的图。

### 技巧 1、提供示例图让 AI 模仿

当你看到一个很棒的图，想要绘制同款时，可以直接截图给 AI，让它帮你生成类似的图。

举个例子，仿照我提供的系统架构图进行生成，这种场景适合使用 draw.io 工具。示例 Prompt 如下：

```plain
请根据我提供的系统架构图，用 draw.io 格式生成类似风格和结构的图，但内容改为：
- 一个在线教育平台的架构
- 保持原图的配色方案和布局风格
- 包含用户端、管理端、API 网关、核心服务、数据存储等模块
```

在 Cursor 中执行：

![](https://pic.yupi.icu/1/1748424661404-2d3fbd7d-a563-4ef7-97c1-3bf82bc6fbf1.png)

生成结果如图，是不是很像？

![](https://pic.yupi.icu/1/1748424880583-92c573bc-fdb2-45d0-b4e0-d2590ea069c5.png)



### 技巧 2、截图标注，精准修改

如果你对 AI 生成的图的有些地方不满意，你可以截图并在需要修改的地方画红圈标注，然后告诉 AI 如何修改，从而实现精准修改。

举个例子，先对生成的架构图进行标注，利用截图工具就可以完成了：

![](https://pic.yupi.icu/1/1748424987920-e61af63a-b688-4cf8-8cd5-e05df1d412c9.png)

然后将标注过的图片和下列 Prompt 一起发送给 AI：

```plain
我在图片上用红圈标注了几个地方，请帮我进行修改。
其他部分保持不变，并输出新的 draw.io 格式的图片：
1. 第一个红圈：字体换行了，导致内容显示不全
2. 第二个红圈：2 个斜箭头不是特别好看
3. 第三个红圈：字体换行了，应该在同一行显示
```

生成结果如图：

![](https://pic.yupi.icu/1/1748425471345-3f67f7ee-9de7-4c61-85f6-8b9619631f28.png)

可以发现大多数问题都已经修复了，但缺点是 AI 会重新生成一遍图片，每次都要等一段时间。运气不好的话要浪费好多时间在和 AI 斗智斗勇上。。。

### 技巧 3：配置专业的系统预设

AI 生成的效果很大程度上取决于输入的提示词，所以要让 AI 画出更专业的图，配置一个好的系统提示词至关重要。在 Cursor 中，我们可以设置项目级别的 Rules 规则，让 AI 始终遵循你的绘图规范。

给大家一个专业的架构图绘制预设，仅供参考：

```plain
# 技术架构图绘制专家

你是一名资深的系统架构师和技术图表设计专家，精通各种技术栈和绘图工具。

## 绘图原则
1. 所有文字必须使用简体中文
2. 保持图表简洁清晰，避免过度复杂
3. 使用标准的技术图标和符号
4. 配色专业，一般使用蓝、绿、橙等技术感色彩
5. 层次分明，主次关系清晰

## 技术规范
1. 架构图分层清晰：展示层、网关层、服务层、数据层
2. 使用虚线表示异步调用，实线表示同步调用
3. 标注关键技术栈和中间件
4. 添加必要的文字说明，但不要过多
5. 考虑高可用、负载均衡等架构要素

## 输出要求
1. 根据图表类型和复杂度选择 Mermaid、PlantUML 或 draw.io 语法
2. 如果是复杂架构，分模块逐步展示

## 配色方案
- 展示层：蓝色系 (#3498db)
- 业务层：绿色系 (#2ecc71)
- 数据层：橙色系 (#e67e22)
- 中间件：紫色系 (#9b59b6)
- 错误/警告：红色系 (#e74c3c)
```

进入 Cursor 的 Rules 设置界面，添加一个规则：

![](https://pic.yupi.icu/1/1748425980420-a63384ed-9e6a-4b2c-b736-d8ff2e6ca6ba.png)

将这个预设配置到规则中，可以设置为每次对话都生效，也可以人工按需使用，我这里设置为人工按需使用：

![](https://pic.yupi.icu/1/1748426020674-a7e0a142-5667-4cdc-a263-2789b395edb6.png)

在 AI 对话时指定 Cursor Rules，AI 就会按照规则来生成图片，确保输出的一致性和专业性：

![](https://pic.yupi.icu/1/1748426169737-c9f1fcfd-ec03-4a82-9c02-7874762671f4.png)

生成效果如图，是不是有内味儿了~

![](https://pic.yupi.icu/1/1748426344742-b36e2f36-e4a0-47b2-82ca-52c92c38a0b0.png)



### 技巧 4、组合生成

有时你也不知道哪种方法作图效果最好，干脆就同时生成多种不同的绘图代码，再从中挑选。

示例提示词如下：

```plain
请帮我绘制一个用户登录流程图，要求同时生成下列格式的代码：
1. Mermaid
2. PlantUML
3. draw.io
```

但是这个技巧大家了解一下就好了，实际使用时生成速度会慢很多，成本会比较大。



## 结尾

看到这里，相信你已经掌握了 AI 画图的各种姿势了！从简单的文本绘图到复杂的动态图表，AI 都能轻松搞定。不仅能帮我们节省大量时间，而且妈妈再也不用担心我的图画得丑了！

最后，如果你觉得本期内容对你有帮助，别忘了点赞收藏，分享给更多需要的朋友。学编程、对 AI 感兴趣的朋友欢迎关注鱼皮，在我免费开源的 [AI 知识库](https://ai.codefather.cn) 中也汇总了大量 AI 知识和教程干货，希望对大家有帮助。

![](https://pic.yupi.icu/1/1748059604435-448a391d-74b0-49f0-a7c5-bc72ac56e374-20250530125350228.png)

也欢迎加入我们的 AI 交流群，获得更多最新资讯、AI 玩法等内容～

![AI交流群](https://pic.yupi.icu/yuyi/640-20250530155801513-20250530155847492.png)